global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob_5_5Prop")
local handlestate

handlestate = 0

-- materialise/dematerialise

global function AnimDone()
	local anim
	local drum = FindNodeByName("drum")
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_P05_Handle_Materialise_Anim_Panel05_Handle_Materialise_Down_Idle")	
	else
		anim = FindNodeByShortName("EM_ANIMATOR_P05_Handle_Materialise_Anim_Panel05_Handle_Materialise_Up_Idle")
		drum:Trigger()
	end

	prop:PlayAnim(anim, 1, 0)
	controls.script.TurnOnInterface()
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayUp()
	local anim = FindNodeByShortName("EM_ANIMATOR_P05_Handle_Materialise_Anim_Panel05_Handle_Materialise_Up")

	handlestate = 1

	FindNodeByName("Ob5_5SoundUp"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayDown()
	local anim = FindNodeByShortName("EM_ANIMATOR_P05_Handle_Materialise_Anim_Panel05_Handle_Materialise_Down")

	handlestate = 0

	FindNodeByName("Ob5_5SoundDown"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")

	controls.script.TurnOffInterface()

	if (handlestate == 0) then
		PlayUp()
	else
		PlayDown()
	end

	FindNodeByName("Console5InteractableScript").script.Object5State = handlestate 

	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text
			doctor::SID_2471:Materialise/Dematerialise Function: This engages the engines, and makes the TARDIS appear and disappear. Leave the handbrake on, it makes a lovely sound.
		else
			--VO Console Control Text
			amy::SID_2472:I definitely know this - it's the one that makes the TARDIS appear and disappear. It's the last thing the Doctor uses before we start moving.
		end
	end
end

global function DummyCallback()
end

global function ResetControl()
	local anim
	
	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_P05_Handle_Materialise_Anim_Panel05_Handle_Materialise_Down_Idle")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_P05_Handle_Materialise_Anim_Panel05_Handle_Materialise_Down")
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0)
	handlestate = 0
end
